#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7BrpMessage : BaseTest 
	{
		#region Variables & Setup

		private static string _hl7Message;

		HL7BrpMessage _brpMessage;

		static Messages_HL7BrpMessage()
		{
			_hl7Message = string.Concat(
				"MSH^~|\\&^WBC^500^VBECS^500^20040328134623.1234+0300^^BRP~O30^WBC20060303171200^P^2.5",
				CARRIAGE_RETURN,
				"MSA^AR^VBEC20060303171117",
				CARRIAGE_RETURN,
				"ERR^^PID~1~3~~1~1^101~Required field missing^E",
				CARRIAGE_RETURN );
		}

		[SetUp]
		public void SetUp()
		{
			_brpMessage = new HL7BrpMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7BrpMessage brpMessage = new HL7BrpMessage( _hl7Message );
			//
			Assert.IsTrue( brpMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7BrpMessage brpMessage = new HL7BrpMessage( null );
			//
			Assert.IsTrue( brpMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _brpMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _brpMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _brpMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _brpMessage.IsResponseRequired() == false );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void AcknowledgementCode_Pass()
		{
			Assert.IsNotNull( _brpMessage.AcknowledgementCode );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AcknowledgementCode_Fail()
		{
		}

		[Test]
		public void ErrorCode_Pass()
		{
			Assert.IsNotNull( _brpMessage.ErrorCode );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ErrorCode_Fail()
		{
		}


		[Test]
		public void ErrorText_Pass()
		{
			Assert.IsNotNull( _brpMessage.ErrorText );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ErrorText_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _brpMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			Assert.IsNotNull( _brpMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _brpMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			Assert.IsNotNull( _brpMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void MSA_Pass()
		{
			Assert.IsNotNull( _brpMessage.MSA );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSA_Fail()
		{
		}

		[Test]
		public void ERR_Pass()
		{
			Assert.IsNotNull( _brpMessage.ERR );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ERR_Fail()
		{
		}
		
		#endregion
	}
}
#endif